<?php
require_once 'admin_config.php';
requireAdminAuth();

// جلب الإحصائيات من قاعدة البيانات مباشرة
// إجمالي المستخدمين
$result = $conn->query("SELECT COUNT(*) as total FROM users");
$stats['total_users'] = $result ? (int)$result->fetch_assoc()['total'] : 0;

// إجمالي المعاملات
$result = $conn->query("SELECT COUNT(*) as total FROM transactions");
$stats['total_transactions'] = $result ? (int)$result->fetch_assoc()['total'] : 0;

// إجمالي الإيرادات (المعاملات المكتملة فقط)
$result = $conn->query("SELECT SUM(amount) as total FROM transactions WHERE status = 'completed'");
$stats['total_revenue'] = $result ? (float)$result->fetch_assoc()['total'] : 0;

// المعاملات المعلقة
$result = $conn->query("SELECT COUNT(*) as total FROM transactions WHERE status = 'pending'");
$stats['pending_transactions'] = $result ? (int)$result->fetch_assoc()['total'] : 0;

// آخر المستخدمين
$result = $conn->query("SELECT * FROM users ORDER BY created_at DESC LIMIT 5");
$users = $result ? $result->fetch_all(MYSQLI_ASSOC) : [];

// آخر المعاملات
$result = $conn->query("SELECT t.*, u.username as user_name 
                        FROM transactions t 
                        LEFT JOIN users u ON t.user_id = u.id 
                        ORDER BY t.created_at DESC LIMIT 5");
$transactions = $result ? $result->fetch_all(MYSQLI_ASSOC) : [];

require_once '../header.php';
?>

<body class="bg-dark text-white">
<div class="container py-4">
    <div class="row">
        <div class="col-md-3">
            <div class="card bg-dark text-white mb-4 border-secondary">
                <div class="card-body">
                    <h5 class="card-title">إجمالي المستخدمين</h5>
                    <h2><?php echo htmlspecialchars($stats['total_users']); ?></h2>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-dark text-white mb-4 border-secondary">
                <div class="card-body">
                    <h5 class="card-title">إجمالي المعاملات</h5>
                    <h2><?php echo htmlspecialchars($stats['total_transactions']); ?></h2>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-dark text-white mb-4 border-secondary">
                <div class="card-body">
                    <h5 class="card-title">إجمالي الإيرادات</h5>
                    <h2><?php echo htmlspecialchars($stats['total_revenue']); ?> $</h2>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-dark text-white mb-4 border-secondary">
                <div class="card-body">
                    <h5 class="card-title">المعاملات المعلقة</h5>
                    <h2><?php echo htmlspecialchars($stats['pending_transactions']); ?></h2>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="card bg-dark text-white mb-4 border-secondary">
                <div class="card-header bg-dark border-secondary">
                    <h5 class="mb-0">آخر المستخدمين</h5>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-dark table-striped">
                            <thead>
                                <tr>
                                    <th>الاسم</th>
                                    <th>البريد الإلكتروني</th>
                                    <th>تاريخ التسجيل</th>
                                    <th>الرصيد</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($users as $user): ?>
                                <tr>
                                    <td><?php echo htmlspecialchars($user['username']); ?></td>
                                    <td><?php echo htmlspecialchars($user['email']); ?></td>
                                    <td><?php echo htmlspecialchars($user['created_at']); ?></td>
                                    <td><?php echo htmlspecialchars($user['balance']); ?> $</td>
                                    <td>
                                        <a href="user.php?id=<?php echo $user['id']; ?>" class="btn btn-sm btn-primary">عرض</a>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="card bg-dark text-white mb-4 border-secondary">
                <div class="card-header bg-dark border-secondary">
                    <h5 class="mb-0">آخر المعاملات</h5>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-dark table-striped">
                            <thead>
                                <tr>
                                    <th>المستخدم</th>
                                    <th>النوع</th>
                                    <th>المبلغ</th>
                                    <th>التاريخ</th>
                                    <th>الحالة</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($transactions as $transaction): ?>
                                <tr>
                                    <td><?php echo htmlspecialchars($transaction['user_name']); ?></td>
                                    <td><?php echo htmlspecialchars($transaction['type']); ?></td>
                                    <td><?php echo htmlspecialchars($transaction['amount']); ?> $</td>
                                    <td><?php echo htmlspecialchars($transaction['created_at']); ?></td>
                                    <td>
                                        <span class="badge bg-<?php echo $transaction['status'] === 'completed' ? 'success' : 'warning'; ?>">
                                            <?php echo htmlspecialchars($transaction['status']); ?>
                                        </span>
                                    </td>
                                    <td>
                                        <?php if ($transaction['status'] === 'pending'): ?>
                                        <form method="POST" action="approve-transaction.php" class="d-inline">
                                            <input type="hidden" name="transaction_id" value="<?php echo $transaction['id']; ?>">
                                            <button type="submit" class="btn btn-sm btn-success">موافقة</button>
                                        </form>
                                        <form method="POST" action="reject-transaction.php" class="d-inline">
                                            <input type="hidden" name="transaction_id" value="<?php echo $transaction['id']; ?>">
                                            <button type="submit" class="btn btn-sm btn-danger">رفض</button>
                                        </form>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
</body>

<?php require_once '../footer.php'; ?> 